<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Support\Facades\Config;

class FeatureFlagsTest extends TestCase
{
    /** @test */
    public function checkout_route_403_when_feature_disabled(): void
    {
        Config::set('features.features.checkout', false);
        $this->actingAs(\App\Models\User::factory()->create());
        $this->get('/checkout')->assertStatus(403);
    }

    /** @test */
    public function checkout_route_accessible_when_forced_all_even_if_disabled(): void
    {
        Config::set('features.features.checkout', false);
        putenv('FEATURES_FORCE_ALL=true');
        $dish = \App\Models\Dish::factory()->create();
        $this->withSession(['cart' => ['items' => [$dish->id => 1]]])
            ->actingAs(\App\Models\User::factory()->create());
        $this->get('/checkout')->assertStatus(200);
        putenv('FEATURES_FORCE_ALL=');
    }
}
