<?php

namespace Tests\Feature\Inventory;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\User;
use App\Models\Dish;
use App\Models\Location;

class AdminTransferFormTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Create user and disable middleware for admin routes in this test suite
        $this->user = User::factory()->create();
        $this->actingAs($this->user);
        $this->withoutMiddleware();
    }

    public function test_transfer_form_displays()
    {
        $response = $this->get(route('admin.inventory.transfer.form'));
        $response->assertStatus(200);
        $response->assertSee('Transfer Stock');
    }

    public function test_transfer_store_creates_movements()
    {
        $dish = Dish::factory()->create(['stock' => 10]);
        $a = Location::create(['name' => 'Main','code' => 'MAIN']);
        $b = Location::create(['name' => 'Outlet','code' => 'OUT']);

        $response = $this->post(route('admin.inventory.transfer.store'), [
            'dish_id' => $dish->id,
            'from_location_id' => $a->id,
            'to_location_id' => $b->id,
            'quantity' => 3,
            'note' => 'Shift stock',
        ]);

        $response->assertRedirect(route('admin.inventory.movements'));
        $response->assertSessionHas('status', 'Transfer recorded');

        $this->assertDatabaseHas('inventory_movements', [
            'dish_id' => $dish->id,
            'location_id' => $a->id,
            'reason' => 'transfer_out',
            'change' => -3,
        ]);
        $this->assertDatabaseHas('inventory_movements', [
            'dish_id' => $dish->id,
            'location_id' => $b->id,
            'reason' => 'transfer_in',
            'change' => 3,
        ]);
    }
}
