<?php

namespace Tests\Feature\Orders;

use App\Models\Order;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class OrderStatusJsonTest extends TestCase
{
    use RefreshDatabase;

    public function test_guest_cannot_access_status_json(): void
    {
        $order = Order::factory()->create();
        $this->get(route('orders.status.json', $order))->assertRedirect();
    }

    public function test_user_cannot_access_someone_elses_order(): void
    {
        $owner = User::factory()->create();
        $intruder = User::factory()->create();
        $order = Order::factory()->for($owner)->create();

        $this->actingAs($intruder)
            ->getJson(route('orders.status.json', $order))
            ->assertStatus(403);
    }

    public function test_owner_gets_status_payload(): void
    {
        $user = User::factory()->create();
        $order = Order::factory()->for($user)->create();

        $this->actingAs($user)
            ->getJson(route('orders.status.json', $order))
            ->assertOk()
            ->assertJsonStructure([
                'ok','db_unavailable','id','status','created_at','updated_at','eta'
            ])
            ->assertJson(['ok' => true, 'db_unavailable' => false, 'id' => $order->id]);
    }
}
