<?php

namespace Tests\Feature;

use Tests\TestCase;

class RoutesDiagnosticTest extends TestCase
{
    public function test_dump_named_routes(): void
    {
        $routes = collect(app('router')->getRoutes()->getRoutes())
            ->map(fn($r) => [$r->uri(), $r->getName()])
            ->filter(fn($x) => $x[1])
            ->values();
        fwrite(STDERR, "Named routes count: ".count($routes)."\n");
        foreach ($routes as [$uri,$name]) {
            if (in_array($name, ['home','menu.index'])) {
                fwrite(STDERR, "Route: $name => /$uri\n");
            }
        }
        $this->assertTrue($routes->contains(fn($x) => $x[1] === 'home'), 'home route missing');
        $this->assertTrue($routes->contains(fn($x) => $x[1] === 'menu.index'), 'menu.index route missing');

        // Quick sanity: dispatch a manual request through the router (not HTTP kernel helper)
        $resp = $this->get('/');
        fwrite(STDERR, "Direct GET / status: {$resp->status()}\n");

        // Dump the matched route (if any)
        $current = app('router')->getCurrentRoute();
        if ($current) {
            fwrite(STDERR, 'Matched route name: '.($current->getName() ?: 'null')." uri=".$current->uri()."\n");
        } else {
            fwrite(STDERR, "No current route matched (router returned null)\n");
        }
    }
}
