<?php

namespace Tests\Unit;

use App\Support\ImageManifest;
use Tests\TestCase;

class ImageManifestTest extends TestCase
{
    /** @test */
    public function it_gracefully_handles_missing_manifest_file(): void
    {
        // Ensure file does not exist (rename temporarily if it does).
        $path = ImageManifest::path();
        $backup = null;
        if (is_file($path)) {
            $backup = $path.'.bak';
            @rename($path, $backup);
        }
        try {
            $this->assertNull(ImageManifest::get(true));
            $this->assertNull(ImageManifest::find('dish','anything'));
        } finally {
            if ($backup && is_file($backup)) {
                @rename($backup, $path);
            }
        }
    }
}
