<?php

namespace Tests\Unit\Services\Inventory;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\Dish;
use App\Models\Location;
use App\Models\User;
use App\Services\Inventory\InventoryService;
use Illuminate\Validation\ValidationException;

class InventoryTransferTest extends TestCase
{
    use RefreshDatabase;

    private InventoryService $svc;
    private Dish $dish;
    private User $user;
    private Location $locA;
    private Location $locB;

    protected function setUp(): void
    {
        parent::setUp();
        $this->svc = app(InventoryService::class);
        $this->user = User::factory()->create();
        $this->dish = Dish::factory()->create(['stock' => 10]);
        $this->locA = Location::create(['name' => 'Main Kitchen','code' => 'MAIN']);
        $this->locB = Location::create(['name' => 'Bar','code' => 'BAR']);
    }

    public function test_transfer_creates_paired_movements()
    {
        [$out, $in] = $this->svc->transfer($this->dish, 3, $this->locA, $this->locB, $this->user, 'Move to bar');

        $this->assertEquals('transfer_out', $out->reason);
        $this->assertEquals('transfer_in', $in->reason);
        $this->assertNotNull($out->transfer_group);
        $this->assertEquals($out->transfer_group, $in->transfer_group);
        $this->assertEquals($this->locA->id, $out->location_id);
        $this->assertEquals($this->locB->id, $in->location_id);

        // Stock should remain the same globally after paired movements (decrement then increment)
        $this->dish->refresh();
        $this->assertEquals(10, $this->dish->stock);
    }

    public function test_transfer_requires_positive_quantity()
    {
        $this->expectException(ValidationException::class);
        $this->svc->transfer($this->dish, 0, $this->locA, $this->locB, $this->user);
    }
}
